function ac_sc = ac_Stark_allmixed_hfs(T, I, F_X, MF_X, L)

% For a given transition between the X <--> A state, calculate ac shift and
% scattering rate
% Eg. For T = 'Q12(3/2)', I = 2, F'' = 1.5, MF'' = 1.5 and some laser
% wavelengths specified as [-x x]

%% Constants of transition

%Langhoff87: The Journal of Chemical Physics87, 4716 (1987); doi: 10.1063/1.452835

Aband=0.3856e5;                     % [s^-1] - Tgiaken from Langhoff87
h=6.62607004e-34;                   % [J*sec] planck constant E=h*v
%P=2e-3;%3.68e-3;%11.3/(6.5)*1e-3;   % [Watt] Laser Power 
%Waist=25e-6;                        % [m] Laser Beam Waist

% P=2e-3; % [Watt]
% Waist=25e-6;

P=2.258e-3; % [Watt]
Waist=25e-6;

Intensity=2*P/pi/Waist^2          % [Watt/m^2] Laser Intensity

Intensity=0.93*Intensity; %reduce by the ion's shift

c=299792458;                        % [m/s] Speed of light

% Other Laser Parameters
L = L*1e-9;                         % [m] Laser frequency
w = 2*pi*c./L;                      % [rad/sec] Laser angular frequency

p = 0;                              % Laser Polarization. For p = 0 transition
MF_A = p + MF_X;                    % This comes from selection rules of the transition

%% Decoding transition
Fn_X = str2double(T(3));                                    % F number of the X electronic state
Fn_A = str2double(T(2));                                    % F number of the A electronic state
J_X=str2double(T((strfind(T,'(')+1):(strfind(T,'/')-1)))/...
    str2double(T((strfind(T,'/')+1):(strfind(T,')')-1)));   % J number of the X electronic state

switch T(1)                                                 % J number of the A electronic state
    case 'P'
        J_A=J_X-1;
    case 'Q'
        J_A=J_X;
    case 'R'
        J_A=J_X+1;
    otherwise
        disp('Bad J_A !');
        return;
end

switch Fn_X                                                 % N number of the X state
    case 1
        N_X = J_X - 0.5;
    case 2
        N_X = J_X + 0.5;
    otherwise
        disp('Bad Fn_X !');
        return;
end

ac = 0;                                                     % Total ac-shift
sc = 0;                                                     % Total scattering rate

%% Sanity checks to ensure that the given transitions/levels exists

if ((J_A < 0))                                              % J number cannot be less than 0
    ac = 0;
    sc = sc + 0;
    ac_sc{1} = ac;
    ac_sc{2} = sc;
    return;
end

if ((Fn_A == 1)&&(J_A < 1.5))                               % For F1 states in A, no J < 3/2
    ac = 0;
    sc = sc + 0;
    ac_sc{1} = ac;
    ac_sc{2} = sc;
    return;
end

if ((Fn_A == 2)&&(J_A < 0.5))                               % For F2 states in A, no J < 1/2
    ac = 0;
    sc = sc + 0;
    ac_sc{1} = ac;
    ac_sc{2} = sc;
    return;
end


%% Energy and Eigenvector of X state

% Calculates energy [cm-1] and mixing coefficients for the X state
[V_X, E_X] = hamiltonian_XState_hfs(Fn_X, J_X, I, F_X);     

if ~(E_X == 0)
    E_X = 1e-2/E_X;             % [m] X state frequency
    E_X=2*pi*c./E_X;            % [rad/sec] X state angular frequency
end

%S_hl = 0; % total Honl-Lonfon factor

% Transition to all possible hyperfine levels of the A state
for F_A = abs(J_A - I):1:(J_A + I)
    
    hl = 0;                     % Total hl factor for a particular F_A
    
    % Calculates energy [cm-1] and mixing coefficients for the A state
    [V_A, E_A] = hamiltonian_AState_hfs_v2(Fn_A, J_A, I, F_A);
    
    E_A = 1e-2/E_A;             % [m] A state frequency
    E_A=2*pi*c./E_A;            % [rad/sec] A state angular frequency
    
    w0 = E_A - E_X;             % [rad/sec] transition frequency
    
    %     w0 = XA20bandTrans_Wu(T);
    %     w0 = 1e-2/w0; %[m] A state frequency
    %     w0=2*pi*c./w0; % [rad/sec] A state angular frequency
    
    
    % Since the file that calculates the A state mixing can return either
    % a 3x3 or 5x5 or 6x6 matrix, I convert it to 6x6 format. 
    
    % The minus signs below ensure that the resultant mixed state has negative parity.  
    if (size(V_A, 1) == 3)
         V_A = [0 0 V_A(1) -0 -V_A(2) -V_A(3)];
         %V_A = [0 0 V_A(1) -0 V_A(2) V_A(3)];
    elseif (size(V_A,1) == 5)
        V_A = [0 V_A(1) V_A(2) -V_A(3) -V_A(4) -V_A(5)];
        %V_A = [0 V_A(1) V_A(2) V_A(3) V_A(4) V_A(5)];
    elseif (size(V_A,1) == 6)
        V_A = [V_A(1) V_A(2) V_A(3) -V_A(4) -V_A(5) -V_A(6)];
        %V_A = [V_A(1) V_A(2) V_A(3) V_A(4) V_A(5) V_A(6)];
        
    end
    
    for ii = 1:1:2                   % Index for kets |> of the X state
        
        if (V_X(ii) == 0)
            hl = hl + 0;
            ac = ac + 0;
            sc = sc + 0;
            ac_sc{1} = ac;
            ac_sc{2} = sc;
            continue;
        elseif (ii == 1)
            J_ii = N_X - 1/2;       % The first index is always the F2 state
        else
            J_ii = N_X + 1/2;       % The second index is always the F1 state
        end
        
        for jj = 1:1:6              % Index for kets |> of the A state
            if (V_A(jj) == 0)
                hl = hl + 0;
                ac = ac + 0;
                sc = sc + 0;
                ac_sc{1} = ac;
                ac_sc{2} = sc;
                continue;
            end
            
            if (jj == 1)            % Defining Omega_A and Sigma_A in the order of the V_A matrix
                Omega_A = 3/2;
                Sigma_A = 1/2;
                J_jj = J_A - 1;
            elseif (jj == 2)
                Omega_A = 3/2;
                Sigma_A = 1/2;
                J_jj = J_A;
            elseif (jj == 3)
                Omega_A = 3/2;
                Sigma_A = 1/2;
                J_jj = J_A + 1;
            elseif (jj == 4)
                Omega_A = 1/2;
                Sigma_A = -1/2;
                J_jj = J_A - 1;
            elseif (jj == 5)
                Omega_A = 1/2;
                Sigma_A = -1/2;
                J_jj = J_A;
            elseif (jj == 6)
                Omega_A = 1/2;
                Sigma_A = -1/2;
                J_jj = J_A + 1;
            end
            
            %hl = hl + V_X(ii)*V_A(jj)*honl_london_allmixed_hfs(Sigma_A, Omega_A, J_jj, J_ii, I, F_A, F_X);
            hl = hl + V_X(ii)*V_A(jj)*honl_london_allmixed_hfs(Sigma_A, Omega_A, J_jj, J_ii, I, F_A, F_X);
            %S_hl(jj) = hl;
        end
        
    end
    
    
    hl = hl^2; % Square of the Honl-London factor
    
    ac = ac - ((3*pi*c^2)/(2*w0^3))*Aband*Intensity*hl*(2*F_A + 1)*Wigner3j([F_A 1 F_X],[-MF_A p MF_X])^2*(1./(w0 - w) + 1./(w0 + w))/h; % [Hz] Ac-Stark Shift
    sc = sc + ((3*pi^2*c^2)/(h*w0^3))*Aband^2*Intensity*hl^2*((1./(w0 - w)) + (1./(w0 + w))).^2.*(w.^3/w0^3)*(2*F_A + 1)^2*Wigner3j([F_A 1 F_X],[-MF_A p MF_X])^4; % Scattering rate
    %disp((hl)/2);
    ac_sc{1} = ac;
    ac_sc{2} = sc;
    
end

%disp((hl)^2/2);

end